﻿using HIPS.CommonSchemas;
using HIPS.Web.UI.ViewModels.Shared;
using HIPS.Web.Components.Common;

namespace HIPS.Web.UI.Helpers
{

    /// <summary>
    /// Provides extension methods related to working with view models.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="24 November 2013">Initial version.</change>
    /// </history>
    public static class ViewModelExtensions
    {

        #region Methods

        /// <summary>
        /// Gets the CSS class used to display an alert for a view message.
        /// </summary>
        /// <param name="message">ViewMessage to display the alert for.</param>
        /// <returns>String containing the CSS class.</returns>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="24 November 2013">Initial version.</change>
        /// </history>
        public static string GetAlertCssClass(this ViewMessage message)
        {
            string result = string.Empty;

            switch (message.Level)
            {
                case (MessageLevel.Information):
                    {
                        result = "alert-info";
                        break;
                    }
                case (MessageLevel.Warning):
                    {
                        result = "alert-warning";
                        break;
                    }
                case (MessageLevel.Error):
                    {
                        result = "alert-danger";
                        break;
                    }
            }

            return result;
        }

        /// <summary>
        /// Gets the CSS class used to display an icon for a view message.
        /// </summary>
        /// <param name="message">ViewMessage to display the alert for.</param>
        /// <returns>String containing the CSS class.</returns>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="24 November 2013">Initial version.</change>
        /// </history>
        public static string GetIconCssClass(this ViewMessage message)
        {
            string result = string.Empty;

            switch (message.Level)
            {
                case (MessageLevel.Information):
                    {
                        result = "glyphicon-info-sign";
                        break;
                    }
                case (MessageLevel.Warning):
                    {
                        result = "glyphicon-question-sign";
                        break;
                    }
                case (MessageLevel.Error):
                    {
                        result = "glyphicon-warning-sign";
                        break;
                    }
            }

            return result;
        }

        #endregion

    }
}
